#include <bits/stdc++.h>
using namespace std;

struct Edge {
    int u,v;
    double w;
    bool operator<(const Edge &e) const { return w<e.w; }
};

struct DSU {
    vector<int> p;
    DSU(int n){ p.resize(n); iota(p.begin(),p.end(),0);}
    int find(int x){ return x==p[x]?x:p[x]=find(p[x]);}
    bool unite(int x,int y){
        x=find(x); y=find(y);
        if(x==y) return false;
        p[y]=x; return true;
    }
};

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n; double eps;
    cin >> n >> eps;
    vector<pair<double,double>> pts(n);
    for(int i=0;i<n;i++) cin >> pts[i].first >> pts[i].second;

    int limit = min(n, (int)(18/(eps*eps)));
    vector<int> Q;
    for(int i=0;i<limit;i++) Q.push_back(i);

    vector<Edge> edges;
    for(int i=0;i<limit;i++){
        for(int j=i+1;j<limit;j++){
            double d = abs(pts[Q[i]].first-pts[Q[j]].first) + abs(pts[Q[i]].second-pts[Q[j]].second);
            edges.push_back({i,j,d});
        }
    }
    sort(edges.begin(),edges.end());

    DSU dsu(limit);
    vector<pair<int,int>> mst;
    for(auto &e:edges){
        if(dsu.unite(e.u,e.v)){
            mst.push_back({Q[e.u]+1, Q[e.v]+1});
            if(mst.size()==limit-1) break;
        }
    }

    cout << limit << "\n";
    for(int x:Q) cout << x+1 << " ";
    cout << "\n";
    for(auto &p:mst) cout << p.first << " " << p.second << "\n";
}